const { contextBridge, ipcRenderer, webUtils } = require("electron");
const { statSync, readFileSync, existsSync } = require("fs");
const crypto = require("crypto");

let checksum = (data) => {
  return crypto.createHash("sha256").update(data).digest("hex");
};

let readFileContent = (path) => {
  if (existsSync(path) && !isFolder(path)) {
    return readFileSync(path, { encoding: "utf-8", flag: "r" });
  }
  return false;
};

let getFileInfo = (file) => {
  try {
    return statSync(file);
  } catch {
    return false;
  }
};

let getConfigDir = async () => {
  return await ipcRenderer.invoke("requestAppData");
};

let isFolder = (path) => {
  try {
    if (statSync(path).isDirectory()) {
      return true;
    } else {
      return false;
    }
  } catch {
    return false;
  }
};

contextBridge.exposeInMainWorld("api", {
  getConfigDir,
  readFileContent,
  getFileInfo,
  isFolder,
  checksum,
  invoke: (channel, ...args) => ipcRenderer.invoke(channel, ...args),
});

// Messaging bridge
contextBridge.exposeInMainWorld("messaging", {
  // Sends data from 'Renderer' to 'Main'
  // Use on 'Main': ipcMain.on(channel, (event, data) => {})
  // Use on 'Renderer': window.messaging.send(channel, data)
  send: (channel, data) => {
    ipcRenderer.send(channel, data);
  },
  // Sends data from 'Main' to 'Renderer'
  // Use on 'Main': window.webContents.send(channel, data)
  // Use on 'Renderer': window.messaging.receive(channel, (data) => {})
  receive: (channel, func) => {
    ipcRenderer.on(channel, (event, ...args) => func(...args));
  },

  invoke: (channel, path) => ipcRenderer.invoke(channel, path),
});

contextBridge.exposeInMainWorld("electronUtils", {
  getPathForFile: (file) => webUtils.getPathForFile(file),
});
