const { contextBridge, ipcRenderer, webUtils } = require("electron");
const crypto = require("crypto");

let checksum = (data) => {
  return crypto.createHash("sha256").update(data).digest("hex");
};

let fileDropCallback = false;

window.addEventListener("drop", (event) => {
  if (!fileDropCallback) return;

  const files = Array.from(event.dataTransfer.files);
  const filePaths = files.map((file) => webUtils.getPathForFile(file));

  fileDropCallback(filePaths, event);
});

contextBridge.exposeInMainWorld("api", {
  checksum,
  onFileDrop: (callback) => {
    fileDropCallback = callback;
  },
  invoke: (channel, ...args) => ipcRenderer.invoke(channel, ...args),
});

// Messaging bridge
contextBridge.exposeInMainWorld("messaging", {
  // Sends data from 'Renderer' to 'Main'
  // Use on 'Main': ipcMain.on(channel, (event, data) => {})
  // Use on 'Renderer': window.messaging.send(channel, data)
  send: (channel, data) => {
    ipcRenderer.send(channel, data);
  },
  // Sends data from 'Main' to 'Renderer'
  // Use on 'Main': window.webContents.send(channel, data)
  // Use on 'Renderer': window.messaging.receive(channel, (data) => {})
  receive: (channel, func) => {
    ipcRenderer.on(channel, (event, ...args) => func(...args));
  },

  invoke: (channel, path) => ipcRenderer.invoke(channel, path),
});
